/* -*-C-*-
 ******************************************************************************
 *
 * File:         xplot.h
 * RCS:         "@(#)$Revision: 1.2 $ $Date: 1996/11/27 00:25:19 $"
 * Description:  include and defines for host programs (HP35635R).
 * Author:       Dan Fortune
 * Created:      Sep  1 1989
 * Language:     C 
 * Package:      HP35635R
 * Status:       "@(#)$State: Exp $"
 *
 * (C) Copyright 1991, Hewlett-Packard Company, all rights reserved.
 *
 ******************************************************************************
 *
 * Use of the lint library (llib-lxplot.ln) will remove the extraneous
 * warning returned from lint.
 *
 * Revisions:
 *
 * Jun 01 1989  Vers 1.0  Dan Fortune/Eric Yamada
 * Feb 05 1991  Added all xplot functions .. ericy
 * Nov 01 1991  Added math functions.. rickk
 *
 * Thu Dec  3 14:28:43 1992 (Eric Backus) ericb@labejb
 *  Added xplot_close_window(), which got left out of A.04.00 somehow.
 ******************************************************************************
*/

#ifndef _TK_XPLOT_INCLUDED
#define _TK_XPLOT_INCLUDED

/* function prototypes */
#ifdef __STDC__
    extern void xplot_change_grids(char *this_plot, int x_grid_type,
                                                             int y_grid_type );
    extern void xplot_change_mode(char *this_plot, int mode );
    extern void xplot_change_plot_to(char *plot, int plot_kind, float span,
                                                               int num_points);
    extern void xplot_change_xautoscale(char *this_plot, int scale );
    extern void xplot_change_xlabel(char *this_plot, char *x_label );
    extern void xplot_change_yautoscale(char *this_plot, int scale );
    extern void xplot_change_ylabel(char *this_plot, char *y_label );
    extern void xplot_check_events(char *this_plot);
    extern void xplot_close_window(char *plot_arg);
    extern void xplot_data_update(char *plot_arg);
    extern char *xplot_init_plot(float *trace_data, int num_points, float span,
                      float y_max, float y_min, int plot_kind,
                      char *place, char *title );
    extern char *xplot_init_plots(float **trace_data, int num_points,
                       float span, float y_max, float y_min, int plot_kind,
                                     char *place, char *title, int num_traces);
    extern void xplot_max_marker(char *this_plot, int state );
    extern void xplot_min_marker( char *this_plot, int state );
    extern void xplot_repaint(char *this_plot_arg);
    extern void xplot_set_display(char *s);
    extern void xplot_set_pname(char *new_progname);
    extern void xplot_set_title (char *plot,char *title);
    extern void xplot_set_xscale (char *this_plot, float x_min, float x_max);
    extern void xplot_set_yscale (char *this_plot, float y_max, float y_min );

    extern int convert_short_data(short *ibuf, float *obuf, int npoint,
                                                            float scaleFactor);
    extern int convert_int_data(int *ibuf, float *obuf, int npoint,
                              int magsquare, int logarithm, float scaleFactor);
    extern int convert_48_data(int *ibuf, float *obuf, int npoint,
                                                            float scaleFactor);
    extern int array_magsq(float *ibuf, int npoint);
    extern int array_log(float *ibuf, int npoint, float scaleFactor);
    extern int array_log_double(float *ibuf, int npoint, double scaleFactor);

    /* The following function seems to be double secret. */
    extern void xplot_set_y_overhead(char *this_plot, float overhead );
#else  /* __STDC__ */
    extern void     xplot_change_grids() ; 
    extern void     xplot_change_mode() ;
    extern void     xplot_change_plot_to() ;
    extern void     xplot_change_xautoscale() ;
    extern void     xplot_change_xlabel() ;
    extern void     xplot_change_yautoscale() ;
    extern void     xplot_change_ylabel() ;
    extern void     xplot_check_events() ;
    extern void     xplot_close_window() ;
    extern void     xplot_data_update() ;
    extern char     *xplot_init_plot() ;
    extern char     *xplot_init_plots() ;
    extern void     xplot_max_marker() ;
    extern void     xplot_min_marker() ;
    extern void     xplot_repaint() ;
    extern void     xplot_set_display() ;
    extern void     xplot_set_pname() ;
    extern void     xplot_set_title() ;
    extern void     xplot_set_xscale() ;
    extern void     xplot_set_yscale() ;

    extern int convert_short_data( );
    extern int convert_int_data( );
    extern int convert_48_data( );
    extern int array_magsq( );
    extern int array_log( );
    extern int array_log_double();

    /* The following function seems to be double secret. */
    extern void xplot_set_y_overhead();
#endif /* __STDC__ */

/* types of traces for xplot_init_plots */
#define TIME_TRACE         1
#define FREQ_LOG_MAG_TRACE 2
#define PHASE_TRACE        3
#define WATERFALL_TRACE    4
#define GENERIC_TRACE      5
#define BAR_GRAPH          6
#define	XPLOT_PIXMAP		0x100	/* Flag to or with above values */

/* modes for xplot_change_mode */
#define NORMAL_MODE     0
#define XY_MODE         1
#define XYZ_MODE        2

/* graph modes for xplot_change_mode */
/* values less than 0 mean one grid line per data point */
#define NO_GRIDS        0
#define ENGR_GRIDS      1       /* "Nice" values for grids */
/* values greater than ENGR_GRIDS give that amount of grid lines */

#ifndef NULL
#define NULL 0
#endif

#endif /* _TK_XPLOT_INCLUDED */
